function getArrayForLetters(letters) {
    
    var charArray = new Array(0);

    if (letters != null) {
        var charArray_temp = new Array(letters.length);
        
        var validCharCount = 0;

        for (var i = 0; i < letters.length; i++) {
            var ch = letters.substring(i, i+1).toUpperCase(); 

            if (ch == "\'") {
                charArray_temp[i] = "Apostrophe";
                ++validCharCount;
            } else if (ch == "-") {
                charArray_temp[i] = "Hyphen";
                ++validCharCount;
            } else if((("0".charCodeAt(0) <= ch.charCodeAt(0)) && (ch.charCodeAt(0) <= "9".charCodeAt(0)))
                        || (("A".charCodeAt(0) <= ch.charCodeAt(0)) && ( ch.charCodeAt(0) <= "Z".charCodeAt(0)))) {
                ++validCharCount;
                charArray_temp[i] = ch;
            }

        }

        //get accurately sized array of valid characters
        charArray = new Array(validCharCount);
        for (var i = 0; i < validCharCount; i++) {
            charArray[i] = charArray_temp[i];
        }
    }

    return charArray;
}

function getArrayForNumbers(numbers) {
    
    var numberArray = new Array(numbers.length);
    for (var i = 0; i < numbers.length; i++) {
        numberArray[i] = numbers.substring(i, i+1);     
    }
    
    return numberArray;
}

function trim(value) {
    while (value.substring(0, 1) == ' ') {
        value = value.substring(1, value.length);
    }

    while (value.substring(value.length - 1, value.length) == ' ') {
        value = value.substring(0, value.length - 1);
    }
    
    return value;
}

function getConvertedNumberArray(numbers) {

    if (numbers == null) {
        return "";
    }

    try
    {
        numbers = trim(numbers);
        var promptArray = new Array(1); //let it grow as needed
        var number = parseInt(numbers);

        if (number <= 0) {
            return spellBack(numbers);
        } else if (number < 20) {
            promptArray[0] = number;
            return promptArray;
        } else if (number < 100) {        
            var tensDigit = parseInt(number / 10);
            var onesDigit = parseInt(number % 10);
                        
            promptArray[0] = tensDigit + "0";

            if (onesDigit != 0) {
                promptArray[1] = onesDigit;
            }

            return promptArray;
        } else if (number < 1000) {
            var hundredsDigit = parseInt(number / 100);
            var twoDigitRemainder = parseInt(number % 100);
            
            if (twoDigitRemainder == 0) {
                promptArray[0] = hundredsDigit + "00";

                return promptArray;
            }

            promptArray[0] = hundredsDigit;

            var tensDigit = parseInt(twoDigitRemainder / 10);
            if (tensDigit == 0) {
                promptArray[1] = "0";
            }

            var extraArray = getConvertedNumberArray(twoDigitRemainder + ""); //force to string

            var startingLength = promptArray.length;
            for (var i = 0; i < extraArray.length; i++) {
                promptArray[i + startingLength] = extraArray[i];
            }

            return promptArray;

        } else {
            return getArrayForNumbers(numbers);
        }
    } catch(er) {
        return getArrayForNumbers(numbers);
    }
}