<?php echo "<?xml version=\"1.0\"?>\n"; ?>
<!DOCTYPE vxml PUBLIC '-//Nuance/DTD VoiceXML 1.0b//EN' 'http://community.voxeo.com/vxml/nuancevoicexml.dtd'> 
<!-- ==================================================== -->
<!--  copyright 2001 by voxeo corporation (see LGPL.txt)  -->
<!-- ==================================================== -->
<?php
// ---------------------------------------------------- 
// Retrieve the file size for the fgets function below. 
// ---------------------------------------------------- 
$fsize = filesize("knock.txt");

// ----------------------------------- 
// Open a connection to the text file. 
// ----------------------------------- 
$filePointer = fopen("knock.txt", "r");

// ------------------------------------ 
// Iterate through the file, reading in 
// each line as a separate array entry. 
// ------------------------------------ 
while(!feof($filePointer)) {
  $jokeArray[] = fgets($filePointer, $fsize+100);
} // while

// --------------------------------------- 
// Generate a random number between 1 and  
// the total number of jokes. Seed with    
// microseconds since last "whole" second. 
// --------------------------------------- 
mt_srand((double)microtime() * 1000000);
$key = mt_rand(1, count($jokeArray));

// ----------------------------------- 
// Split the randomly selected string. 
// ----------------------------------- 
$delim = strpos($jokeArray[$key], ":");
$setup = substr($jokeArray[$key], 0, $delim);
$delivery = substr($jokeArray[$key], $delim+1);

// -------------------------------------- 
// Close the connection to the text file. 
// -------------------------------------- 
fclose($filePointer);
?>
<vxml version="1.0">
  <?php // <property name="caching" value="safe" /> ?>

  <property name="com.nuance.core.ep.EndSeconds" value=".2" />
  <property name="com.nuance.core.ep.PrepareForBargeIn" value="TRUE" />
  <property name="com.nuance.core.ep.ThresholdSnr" value="5" />

  <form id="knockknock">
	<field name="knock" slot="knock">
	  <grammar type="text/gsl" src="knock.grammar#WHOS_THERE" />
	  <prompt bargein="false">Knock knock!</prompt>
      <filled namelist="knock" mode="any"></filled>
	</field>
	
	<field name="setup" slot="setup">
          <property name="confidencelevel" value="0.3"/>
	  <grammar type="text/gsl" src="knock.grammar#MSG_WHO" />
	  <prompt bargein="true"><?php echo $setup; ?></prompt>
	  <filled namelist="setup" mode="any"></filled>
	</field>
	
	<block>
	  <?php echo $delivery; ?>
	</block>
	
	<field name="again" slot="again">
	  <grammar type="text/gsl" src="knock.grammar#YES_NO" />
	  <prompt bargein="false">
	    <break />
	    Would you like to hear another?
	  </prompt>
	  <filled namelist="again" mode="any">
	    <var name="answer" expr="again" />
	    <if cond="answer == 'yes'">
	      <goto next="knock.php" />
	    <elseif cond="answer == 'no'" />
	      <prompt bargein="false">Thank you!</prompt>
		  <exit />
	    </if>
	  </filled>
	</field>
  </form>
</vxml>


