<?xml version="1.0"?>

 
<!-- ==================================================== -->
<!--  copyright 2003 by voxeo corporation (see LGPL.txt)  -->
<!-- ==================================================== -->
<%
Dim tempConnection, tempSQL, tempDatabase, totalJokes, key, setup, delivery

' ---------------------------------- 
' Open a connection to the database. 
' ---------------------------------- 
Set tempConnection = Server.CreateObject("ADODB.Connection")
tempConnection.Open "Knock"

' -------------------------------------- 
' Query for the total number of entries. 
' -------------------------------------- 
tempSQL = "select count(*) as totalJokes from Knock"
Set tempDatabase = tempConnection.Execute(tempSQL)
totalJokes = tempDatabase("totalJokes")

' ---------------------------------------- 
' Generate a random integer in that range. 
' ---------------------------------------- 
Randomize()
key = Int(totalJokes * Rnd() + 1)

' ---------------- 
' Retrieve a joke. 
' ---------------- 
tempSQL = "select * from Knock where Key=" & key 
Set tempDatabase = tempConnection.Execute(tempSQL)

While ( NOT tempDatabase.EOF )
  setup = tempDatabase("Setup")
  delivery = tempDatabase("Delivery")
  tempDatabase.MoveNext
WEnd 'while

' ------------------------------------- 
' Close the connection to the database. 
' ------------------------------------- 
tempDatabase.Close
tempConnection.Close
Set tempDatabase = Nothing
Set tempConnection = Nothing
%>
<vxml version="2.0">
  <% '<property name="caching" value="safe" /> %>
  <property name="com.nuance.core.ep.EndSeconds" value=".2" />
  <property name="com.nuance.core.ep.PrepareForBargeIn" value="TRUE" />
  <property name="com.nuance.core.ep.ThresholdSnr" value="5" />
  <form id="knockknock">
	<field name="knock" slot="knock">
	  <grammar type="text/gsl" src="knock.grammar#WHOS_THERE" />
	  <prompt bargein="false">Knock knock!</prompt>
      <filled mode="any"></filled>
	</field>
	
	<field name="setup" slot="setup">
          <property name="confidencelevel" value="0.3"/>
	  <grammar type="text/gsl" src="knock.grammar#MSG_WHO" />
	  <prompt bargein="true"><%= setup %></prompt>
	  <filled mode="any"></filled>
	</field>
	
	<block>
	  <%= delivery %>
	</block>
	
	<field name="again" slot="again">
	  <grammar type="text/gsl" src="knock.grammar#YES_NO" />
	  <prompt bargein="false">
	    <break />
	    Would you like to hear another?
	  </prompt>
	  <filled mode="any">
	    <var name="answer" expr="again" />
	    <if cond="answer == 'yes'">
	      <goto next="knock_db.asp" />
	    <elseif cond="answer == 'no'" />
	      <prompt bargein="false">Thank you!</prompt>
		  <exit />
	    </if>
	  </filled>
	</field>
  </form>
</vxml>