<?xml version="1.0"?>


<!-- ==================================================== -->
<!--  copyright 2001 by voxeo corporation (see LGPL.txt)  -->
<!-- ==================================================== -->
<%
Dim fso, readStream, jokeDict, totalJokes, key, jokeString, delim, setup, delivery

' ----------------------------------- 
' Open a connection to the text file. 
' 1 = ForReading 
' ----------------------------------- 
Set fso = Server.CreateObject("Scripting.FileSystemObject")
Set readStream = fso.OpenTextFile(Server.MapPath("knock.txt"), 1)

' -------------------------------------------------- 
' Iterate through the file, reading each line into a 
' Dictionary object with the line number as the key. 
' -------------------------------------------------- 
Set jokeDict = CreateObject("Scripting.Dictionary")

Do While readStream.AtEndOfStream = False
  jokeDict.Add readStream.Line, readStream.ReadLine
  totalJokes = totalJokes + 1
Loop

' ----------------------------------- 
' Generate a random integer; the      
' range is the total number of jokes. 
' ----------------------------------- 
Randomize()
key = Int(totalJokes * Rnd() + 1)

' --------------------------------- 
' Split a randomly selected string. 
' --------------------------------- 
jokeString = CStr(jokeDict.Item(key))
delim = CInt(InStr(jokeString, ":")) 
setup = Left(jokeString, delim-1)
delivery = Mid(jokeString, delim+1)

' -------------------------------------- 
' Close the connection to the text file. 
' -------------------------------------- 
readStream.Close
Set readStream = Nothing
Set fso = Nothing
%>
<vxml version="2.0">
  <% '<property name="caching" value="safe" /> %>
  <property name="com.nuance.core.ep.EndSeconds" value=".2" />
  <property name="com.nuance.core.ep.PrepareForBargeIn" value="TRUE" />
  <property name="com.nuance.core.ep.ThresholdSnr" value="5" />

  <form id="knockknock">
	<field name="knock" slot="knock">
	  <grammar type="text/gsl" src="knock.grammar#WHOS_THERE" />
	  <prompt bargein="false">Knock knock!</prompt>
      <filled mode="any"></filled>
	</field>
	
	<field name="setup" slot="setup">
	  <grammar type="text/gsl" src="knock.grammar#MSG_WHO" />
	  <prompt bargein="true"><%= setup %></prompt>
	  <filled mode="any"></filled>
	</field>
	
	<block>
	  <%= delivery %>
	</block>
	
	<field name="again" slot="again">
	  <grammar type="text/gsl" src="knock.grammar#YES_NO" />
	  <prompt bargein="false">
	    <break />
	    Would you like to hear another?
	  </prompt>
	  <filled mode="any">
	    <var name="answer" expr="again" />
	    <if cond="answer == 'yes'">
	      <goto next="knock_f.asp" />
	    <elseif cond="answer == 'no'" />
	      <prompt bargein="false">Thank you!</prompt>
		  <exit />
	    </if>
	  </filled>
	</field>
  </form>
</vxml>